using System;
using System.Windows.Forms;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;

namespace BeWise.SharpBuilderTools
{
	public class OTAViewFiles : BaseOTA
	{
		/**************************************************************/
		/*                        Protected
		/**************************************************************/

		protected void DoView(ViewFileMode aViewFileMode) {
			try {
				FrmViewFiles _Frm = new FrmViewFiles();
				_Frm.SetViewFileMode(aViewFileMode);
				_Frm.ShowDialog();
			}
			catch (Exception e) {
				MessageBox.Show(e.Message + "--" + e.StackTrace);
			}
		}
		
		protected void DoViewAllFiles(object aSender, EventArgs AEventArgs) {
			DoView(ViewFileMode.AllFiles);
		}

		protected void DoViewAssemblies(object aSender, EventArgs AEventArgs)
		{
			DoView(ViewFileMode.Assemblies);
		}

		protected void DoViewSourceFiles(object aSender, EventArgs AEventArgs)
		{
			DoView(ViewFileMode.SourceFiles);
		}

		protected void DoViewForms(object aSender, EventArgs AEventArgs)
		{
			DoView(ViewFileMode.Forms);
		}

		protected void DoViewOpenFiles(object aSender, EventArgs AEventArgs)
		{
			DoView(ViewFileMode.OpenFiles);
		}

		/**************************************************************/
		/*                          Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {

			IOTAMainMenuService _MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));
			IOTAMenuItem _MenuItem = null;

			// Forms
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewFormsMenu",
												 "View Forms...");

			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewForms);

			// CS
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewSourceMenu",
												 "View Source files...");

			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewSourceFiles);

			// Assemblies
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewAssembliesMenu",
												 "View Assemblies...");

			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewAssemblies);

			// OpenTabs
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewOpenTabMenu",
												 "View Open Tabs...");

			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewOpenFiles);

			// All
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewModulesMenu",
												 "View Modules...");

			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewAllFiles);

			// Sep1
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												OTAMenuItemLocation.otamlChild,
												"Sep2",
												"-");

			aMenuNames = new string[] {"ViewSourceMenu", "ViewFormsMenu", "ViewAssembliesMenu", "ViewModulesMenu", "ViewOpenTabMenu"};
			aMenuShortCuts = new int[] {16469, 24661, 0, 0, 24699}; // Ctrl u, Ctrl Shift U, 0, 0,
		}
	}
}
